<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Sobre os Projetos - IFSC</title>

    <link rel="stylesheet" href="css/style.css">
  
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>

    <?php include 'includes/header.php'; ?>

    <section class="banner banner-small">
    <img src="img/abelhinha.jpg" alt="Abelha Jandaíra">
    
        <div class="caixa-info">
      <h1>Conheça nossos Projetos</h1>
      <p>Explore os sistemas de monitoramento ambiental <strong>MABEL</strong> e <strong>PTQA</strong> desenvolvidos pelo IFSC Chapecó.</p>
    </div>
  </section>

    <section class="atividades" id="detalhes-projetos">
    <h2>Detalhes e Foco de Monitoramento</h2>
    
    <div class="atividades-grid">
      
            <article class="atividade-item mabel full-width">
        <h3><i class="fas fa-hive"></i> MABEL: Monitoramento de Abelhas</h3>
        <p>
          O sistema <strong>MABEL</strong> (Monitoramento de Abelhas) realiza o acompanhamento de <strong>colmeias artificiais</strong> no câmpus. O foco é a <strong>saúde das abelhas sem ferrão</strong> através da coleta contínua de dados internos e externos.  
          <strong>Variáveis Coletadas:</strong> Temperatura Interna, Temperatura Externa, Umidade Interna e Umidade Externa.  
          <strong>Objetivo:</strong> Fornecer alertas e histórico que ajudam a equipe de pesquisa a identificar padrões de estresse térmico e otimizar a manutenção da colmeia.
        </p>
      </article>
      
            <article class="atividade-item ptqa full-width">
        <h3><i class="fas fa-wind"></i> PTQA: Protótipo de Qualidade do Ar</h3>
        <p>
          O <strong>PTQA</strong> (Protótipo de Qualidade do Ar) monitora parâmetros ambientais no entorno do câmpus IFSC Chapecó. O objetivo principal é a <strong>análise da qualidade do ar</strong> para estudos acadêmicos sobre poluição e ventilação.  
          <strong>Variáveis Coletadas:</strong> Temperatura, Umidade, Pressão Atmosférica, CO₂, Gases Voláteis (TVOC) e Índice de Qualidade do Ar (AQI).  
          <strong>Objetivo:</strong> Permitir análise detalhada das condições ambientais e do conforto térmico, fornecendo dados para melhorias e pesquisas.
        </p>
      </article>

    </div>
  </section>
  
    <section class="nav-buttons">
        <a href="relatorio_mabel.php" class="nav-btn mabel">
      <i class="fas fa-chart-line"></i> Ver Relatórios MABEL
    </a>
    
        <a href="relatorio_ptqa.php" class="nav-btn ptqa">
      <i class="fas fa-chart-bar"></i> Ver Relatórios PTQA
    </a>
  </section>
  <section class="nav-buttons">
        <a href="identificação.php" class="nav-btn">
      <i class="fas fa-chart-bar"></i> Ver identificação
    </a>
  </section>

    <?php include 'includes/footer.php'; ?>

</body>
</html>